<?php
if (!defined('_GNUBOARD_')) exit; //개별 페이지 접근 불가

// 옵션
$wos = apms_options($options, $m_options);
$slide = (int)$wos['slide'];
$item_rows = (int)$wos['slide_garo'];

$slide = ($slide > 0) ? $slide : 1;

//아이템수에 따른 칼럼 계산
switch($item_rows) {
	case '1'	: $item_cols = 12; break;
	case '2'	: $item_cols = 6; break;
	case '3'	: $item_cols = 4; break;
	case '4'	: $item_cols = 3; break;
	case '6'	: $item_cols = 2; break;
	default		: $item_cols = 3; $item_rows = 4; break;
}

// 총추출수
$wos['rows'] = $slide * $item_rows;

$list = apms_item_rows($wos);
$list_cnt = count($list);
if(!$list_cnt) {
	echo '<p class="text-muted text-center">자료가 없습니다.</p>'.PHP_EOL;
	return;
}

// 효과
switch($wos['carousel']) {
	case 'fade'		: $effect = ' slide at-fade'; break;
	case 'up'		: $effect = ' slide at-vertical'; break;
	case 'slide'	: $effect = ' slide'; break;
	case 'show'		: $effect = ''; break;
	default			: $effect = ' slide'; break;
}

// 효과시간
$interval = ($wos['interval']) ? $wos['interval'] : 5000;

// Random Ticker Id
$carousel_id = apms_id();

// 이미지 비율
$img_height = ($wos['thumb_w'] > 0 && $wos['thumb_h'] > 0) ? round(($wos['thumb_h'] / $wos['thumb_w']) * 100, 2) : 100;

// 새상품라벨표시
$label = ($wos['new']) ? $wos['new'] : 'red';

?>

<?php if($effect != 'none') { ?>
	<div class="carousel<?php echo $effect;?> widget-carousel" id="<?php echo $carousel_id;?>" data-ride="carousel" data-interval="<?php echo $interval;?>">
		<div class="carousel-nav">
			<a class="left" href="#<?php echo $carousel_id;?>" role="button" data-slide="prev"><i class="fa fa-angle-left"></i></a>
			<a class="right" href="#<?php echo $carousel_id;?>" role="button" data-slide="next"><i class="fa fa-angle-right"></i></a>
		</div>

	<!-- Wrapper for slides -->
	<div class="carousel-inner">
		<div class="item active">
<?php } else { ?>
	<div class="widget-carousel">
<?php } ?>
			<div class="row">
				<?php for ($i=0; $i < $list_cnt; $i++) { ?>
					<?php if($i > 0 && $i%$item_rows == 0) { ?>
							</div>
						<?php if($effect != 'none') { ?>
							</div>
							<div class="item">
						<?php } ?>
							<div class="row">
					<?php } ?>
					<div class="col-sm-<?php echo $item_cols;?>">
						<div class="carousel-item">
							<div class="figure">
								<?php if($list[$i]['new']) {?>
									<div class="label-band label-<?php echo $label;?>">New</div>
								<?php } ?>
								<div class="label-tack"><?php echo item_icon($list[$i]);?></div>
								<div class="img" style="padding-bottom:<?php echo $img_height;?>%;">
									<a href="<?php echo $list[$i]['href'];?>">
										<img src="<?php echo $list[$i]['img']['src'];?>" alt="<?php echo $list[$i]['img']['alt'];?>">
										<div class="figure-caption en font-11">
											<ul>
												<li><i class="fa fa-shopping-cart"></i> <?php echo $list[$i]['it_sum_qty']; //판매량 ?></li>
												<li><i class="fa fa-pencil"></i> <?php echo $list[$i]['it_use_cnt']; //후기수 ?></li>
												<li><i class="fa fa-thumbs-up"></i> <?php echo $list[$i]['pt_good']; //추천수 ?></li>
												<li><?php echo apms_get_star($list[$i]['it_use_avg']); ?></li>
											</ul>
										</div>
									</a>
								</div>
							</div>
							<h2>
								<a href="<?php echo $list[$i]['href'];?>">
									<?php if($wos['rank']) { ?>
										<span class="en widget-rank-icon widget-rank-<?php echo $wos['rank'];?>"><?php echo $i+1;?></span>
									<?php } ?>
									<?php echo $list[$i]['it_name'];?>
								</a>
							</h2>
							<div class="item-info en font-14 text-muted">
								<span class="pull-left">
									<i class="fa fa-comment"></i> 
									<?php echo ($list[$i]['pt_comment']) ? '<span class="red">'.number_format($list[$i]['pt_comment']).'</span>' : 0;?>
									<?php if($list[$i]['it_point']) { ?>
										&nbsp;
										<i class="fa fa-gift"></i> 
										<?php echo ($list[$i]['it_point_type'] == 2) ? $list[$i]['it_point'].'%' : number_format(get_item_point($list[$i]));?>
									<?php } ?>
								</span>
								<span class="pull-right black">
									<b><?php echo ($list[$i]['it_tel_inq']) ? 'Call' : number_format($list[$i]['it_price']);?></b>
								</span>
								<div class="clearfix"></div>
							</div>
						</div>
						<?php if($wos['sns']) { ?>
							<p class="text-center">
								<?php 
									$sns_url  = G5_SHOP_URL.'/item.php?it_id='.$list[$i]['it_id'];
									$sns_title = get_text($list[$i]['it_name']);
									$sns_img = THEMA_URL.'/assets/img';
									echo  get_sns_share_link('facebook', $sns_url, $sns_title, $sns_img.'/sns_fb_s.png').' ';
									echo  get_sns_share_link('twitter', $sns_url, $sns_title, $sns_img.'/sns_twt_s.png').' ';
									echo  get_sns_share_link('googleplus', $sns_url, $sns_title, $sns_img.'/sns_goo_s.png').' ';
									echo  get_sns_share_link('kakaostory', $sns_url, $sns_title, $sns_img.'/sns_kakaostory_s.png').' ';
									echo  get_sns_share_link('kakaotalk', $sns_url, $sns_title, $sns_img.'/sns_kakao_s.png', $list[$i]['img']['src']).' ';
									echo  get_sns_share_link('naverband', $sns_url, $sns_title, $sns_img.'/sns_naverband_s.png').' ';
								?>
							</p>
						<?php } ?>
					</div>
				<?php } ?>
			</div>
		</div>	
<?php if($effect != 'none') { ?>
		</div>
	</div>
<?php } ?>
